/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.xml;

import cz.insophy.inplan.xml.XmlSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class XmlReader {
    public static Document readWithoutValidation(@Nonnull XmlSource source, @Nullable ErrorHandler errorHandler) throws IOException, DocumentException {
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        SAXReader reader = new SAXReader();
        reader.setValidation(false);
        reader.setMergeAdjacentText(true);
        if (errorHandler != null) {
            reader.setErrorHandler(errorHandler);
        }
        return source.read(reader);
    }

    public static Document readWithoutValidation(@Nonnull XmlSource source) throws IOException, DocumentException {
        return XmlReader.readWithoutValidation(source, null);
    }

    public static Document readWithDtdValidation(@Nonnull XmlSource source, @Nullable EntityResolver entityResolver, @Nullable ErrorHandler errorHandler) throws IOException, DocumentException {
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        SAXReader reader = new SAXReader();
        reader.setValidation(true);
        if (entityResolver != null) {
            reader.setEntityResolver(entityResolver);
        }
        if (errorHandler != null) {
            reader.setErrorHandler(errorHandler);
        }
        return source.read(reader);
    }

    public static Document readWithDtdValidation(@Nonnull XmlSource source, @Nullable ErrorHandler errorHandler) throws IOException, DocumentException {
        return XmlReader.readWithDtdValidation(source, null, errorHandler);
    }

    public static Document readWithInternalXsdValidation(@Nonnull XmlSource source) throws ParserConfigurationException, SAXException, IOException, DocumentException {
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        SAXParser parser = factory.newSAXParser();
        parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        SAXReader reader = new SAXReader(parser.getXMLReader());
        reader.setValidation(true);
        return source.read(reader);
    }

    public static Document readWithExternalXsdValidation(@Nonnull XmlSource source, @Nonnull URL schemaUrl) throws ParserConfigurationException, IOException, DocumentException, SAXException {
        return XmlReader.readWithExternalXsdValidation(source, schemaUrl, Collections.emptyMap());
    }

    public static Document readWithExternalXsdValidation(@Nonnull XmlSource source, @Nonnull URL schemaUrl, @Nonnull Map<String, URL> schemas) throws ParserConfigurationException, IOException, DocumentException, SAXException {
        Schema schema;
        try (Resolver resolver = new Resolver(schemas);){
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(resolver);
            schema = schemaFactory.newSchema(schemaUrl);
        }
        catch (Exception e) {
            throw new IOException("Cannot parse schema", e);
        }
        System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        factory.setSchema(schema);
        SAXParser parser = factory.newSAXParser();
        SAXReader reader = new SAXReader(parser.getXMLReader());
        return source.read(reader);
    }

    private static class Resolver
    implements LSResourceResolver,
    AutoCloseable {
        private final Map<String, URL> schemas;
        private final List<Closeable> toClose;

        public Resolver(Map<String, URL> schemas) {
            this.schemas = schemas;
            this.toClose = new ArrayList<Closeable>();
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            InputStream stream;
            if (!type.equals("http://www.w3.org/2001/XMLSchema")) {
                return null;
            }
            URL url = this.schemas.get(namespaceURI);
            if (url == null) {
                return null;
            }
            try {
                stream = url.openStream();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.toClose.add(stream);
            return new Input(publicId, systemId, stream);
        }

        @Override
        public void close() {
            for (Closeable c : this.toClose) {
                try {
                    c.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class Input
    implements LSInput {
        private String publicId;
        private String systemId;
        private final InputStream input;

        public Input(String publicId, String sysId, InputStream input) {
            this.publicId = publicId;
            this.systemId = sysId;
            this.input = input;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return this.input;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        @Override
        public String getStringData() {
            return null;
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }
    }
}

